<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::get('/', function () {
    return redirect('/login');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
Route::get('auth/logout', 'Auth\LoginController@logout')->name('auth.logout');

Route::resource('users', 'UserController');

Route::post('api/users/datatable', [
    'uses' => 'UserController@datatable',
    'as' => 'api.users.datatable'
]);

Route::post('api/change/status', [
    'uses' => 'AppBaseController@updateStatus',
    'as' => 'api.change.status'
]);

Route::post('api/users/delete', [
    'uses' => 'UserController@delete',
    'as' => 'api.users.delete'
]);

Route::resource('general', 'GeneralController');


Route::get('dashboard/{id}/byFamily','HomeController@getStatisticByFamily')->name('dashboard.byFamily');

Route::resource('systemlog', 'SystemLogController');

Route::post('api/systemlog/datatable', [
    'uses' => 'SystemLogController@datatable',
    'as' => 'api.systemlog.datatable'
]);

