@extends('layouts.app')
@section('css')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css"/>
    <link href="global_assets/css/icons/fontawesome/styles.min.css" rel="stylesheet" type="text/css">
@endsection
@section('navigation')
    <a href="{{ route('accesstype.index') }}" class="breadcrumb-item"><i class="icon-stack mr-2"></i> Errores del sistema</a>
    <span class="breadcrumb-item active">Historial</span>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-xl-12">
                @include('flash::message')
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title" style="color:black; font-weight:bold;">Historial de errores del sistema</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-striped table-hover table-sx" id="main-table" style="width:100%;">
                            <thead >
                                <tr style="text-align:center;" >
                                    <th style="display:none">id</th>
                                    <th>Usuario</th>
                                    <th>Controlador</th>
                                    <th>Mensaje</th>
                                    <th>Creado</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.2/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9.10.12/dist/sweetalert2.all.min.js"></script>

<script>
    GenerarReporte()

    function GenerarReporte() {
        $('#main-table').DataTable({
            destroy: true,
            tabIndex: -1,
            paging: true,
            lengthChange: true,
            searching: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [20, 50, 100, -1],
                [20, 50, 100, "Todos"]
            ],
            ajax: {
                url: '{{ route('api.systemlog.datatable') }}',
                type: "post",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                beforeSend: function (req) {
                    $('#main-table').mask("Espere por favor..");
                },
                complete: function (req) {
                    setTimeout(function(){$('#main-table').unmask();}, 1000);
                }
            },
            "drawCallback": function( settings ) {
                $(".tooltips").tooltip({placement: 'top'});
            },
            "pageLength": 20,
            "sDom": '<"pull-left"><"pull-right"f>rt<"pull-left"><"pull-right"><"clear">',
            columns: [
                { data: "id", "visible": false },
                { data: "userName", "autowidth": true, responsivePriority: 1 },
                { data: "controller", "autowidth": true, responsivePriority: 2 },
                { data: "message", "autowidth": true, responsivePriority: 3 },
                { data: "created_at",
                    render: function (data, type, row) {
                        return moment(row.created_at).format("YYYY-MM-DD HH:mm")+" Hrs.";
                    }
                }
            ],
            "order": [[0, "desc"]],
            "language": {
                "sProcessing": "Procesando...",
                "searchPlaceholder": "Búsqueda rápida",
                "sLengthMenu": "Mostrar _MENU_ registros",
                "sZeroRecords": "No se encontraron resultados",
                "sEmptyTable": "Ningún dato disponible en esta tabla",
                "sInfo": "Registros del _START_ al _END_, de _TOTAL_.",
                "sInfoEmpty": "Sin registros.",
                "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                "sInfoPostFix": "",
                "sSearch": "Buscar:",
                "sUrl": "",
                "sInfoThousands": ",",
                "sLoadingRecords": "Cargando...",
                "oPaginate": {
                    "sFirst": "Primero",
                    "sLast": "Último",
                    "sNext": "Siguiente",
                    "sPrevious": "Anterior"
                },
                "oAria": {
                    "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                    "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                }
            },
            "columnDefs": [
                { targets: [4], "className" : "text-center"},
            ],
        })
    }

    </script>
@endsection
