<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Proyecto | M.A</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="/global_assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="/assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="/assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="/assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="/assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<link href="/css/site.css" rel="stylesheet" type="text/css">
	<link href="/global_assets/css/icons/fontawesome/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/global_assets/js/plugins/datatables/datatables.min.css" rel="stylesheet" />
	<link href="/global_assets/js/plugins/loadMask/jquery.loadmask.css" rel="stylesheet" />
    <script src="/global_assets/js/demo_pages/form_select2.js"></script>

    <link rel="apple-touch-icon" sizes="57x57" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="60x60" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="72x72" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="76x76" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="114x114" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="120x120" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="144x144" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="152x152" href="/images/icon/favicon.ico">
    <link rel="apple-touch-icon" sizes="180x180" href="/images/icon/favicon.ico">
    <link rel="icon" type="image/png" sizes="192x192"  href="/images/icon/favicon.ico">
    <link rel="icon" type="image/png" sizes="32x32" href="/images/icon/favicon.ico">
    <link rel="icon" type="image/png" sizes="96x96" href="/images/icon/favicon.ico">
    <link rel="icon" type="image/png" sizes="16x16" href="/images/icon/favicon.ico">
    <link rel="manifest" href="/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="/favicon.ico">
    <meta name="theme-color" content="#ffffff">



    {!! Html::style('/plugins/Inputmask/css/inputmask.css') !!}

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.7.14/css/bootstrap-datetimepicker.min.css">

	<!-- /global stylesheets -->
    @yield('css')

    <style>
        .table {
            width: 100%;
        }

        .btn-group-xs>.btn, .btn-group-xs>.btn>*, .btn-xs>* {
            padding: 1px 5px;
            font-size: 12px !important;
            line-height: 1.5;
            border-radius: 3px;
        }

        #maskfullscreen {
            position: fixed;
            left: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            z-index: -9999;
        }
        @media (min-width: 576px) {
            .modal-dialog-slideout {
                max-width: 650px;
                margin: 1.75rem auto;
            }
        }

        .modal-dialog-slideout {min-height: 100%; margin: 0 0 0 auto;background: #fff; max-width: 700px}
        .modal.fade .modal-dialog.modal-dialog-slideout {-webkit-transform: translate(100%,0)scale(1);transform: translate(100%,0)scale(1);}
        .modal.fade.show .modal-dialog.modal-dialog-slideout {-webkit-transform: translate(0,0);transform: translate(0,0);display: flex;align-items: stretch;-webkit-box-align: stretch;height: 100%;}
        .modal.fade.show .modal-dialog.modal-dialog-slideout .modal-body{overflow-y: auto;overflow-x: hidden;}
        .modal-dialog-slideout .modal-content{border: 0;}
        .modal-dialog-slideout .modal-header, .modal-dialog-slideout .modal-footer {height: 69px; display: block;}
        .modal-dialog-slideout .modal-header h5 {float:left;}

        .col-form-label {
            padding-bottom: 0;
            color: #000;
            font-weight: 500;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 54px;
            height: 28px;
            margin: 0;
        }

        /* Hide default HTML checkbox */
        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        /* The slider */
        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 20px;
            width: 20px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }

        .pull-right {
            float: right !important;
        }

        table.dataTable thead th {
            font-size: 14px;
            padding: 1px 5px;
        }

    </style>
</head>
<body>
<div id="maskfullscreen"></div>
	<!-- Main navbar -->
	<div class="navbar navbar-expand-md navbar-dark">
		<div class="navbar-brand">
			<a href="{{route('home')}}" class="d-inline-block">
				<img src="" alt="" style="max-heigh:30px;height: 30px;">
			</a>
		</div>

		<div class="d-md-none">
			<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar-mobile">
				<i class="icon-tree5"></i>
			</button>
			<button class="navbar-toggler sidebar-mobile-main-toggle" type="button">
				<i class="icon-paragraph-justify3"></i>
			</button>
		</div>

		<div class="collapse navbar-collapse" id="navbar-mobile">
			<ul class="navbar-nav">
				<li class="nav-item">
					<a href="#" class="navbar-nav-link sidebar-control sidebar-main-toggle d-none d-md-block">
						<i class="icon-paragraph-justify3"></i>
					</a>
				</li>
			</ul>

			<span class="badge bg-success ml-md-2 mr-md-auto" style="font-size:14px;">Conectado</span>

			<ul class="navbar-nav">
				<li class="nav-item dropdown dropdown-user">
					<a href="#" class="navbar-nav-link d-flex align-items-center dropdown-toggle" data-toggle="dropdown">
                        <img src="{{ asset(Auth::user()->avatar) }}" class="rounded-circle mr-2" height="40" alt="Usuario">
						<span>{{ Auth::user()->name}}</span>
					</a>
					<div class="dropdown-menu dropdown-menu-right">
						<a href="" class="dropdown-item"><i class="icon-user"></i>Mi Perfil</a>
						<div class="dropdown-divider"></div>
						<a class="dropdown-item" href="{{ route('auth.logout') }}"><i class="icon-exit"></i>Cerrar sesión</a>
					</div>
				</li>
			</ul>
		</div>
	</div>
	<!-- Page content -->
	<div class="page-content">
		<!-- Main sidebar -->
		@include('layouts.sidebar')
		<!-- /main sidebar -->
		<!-- Main content -->
		<div class="content-wrapper">
			<!-- Page header -->
			@include('layouts.pageheader')
			@yield('content')
			<!-- Footer -->
			<div class="navbar navbar-expand-lg navbar-light">
				<div class="navbar-collapse collapse" id="navbar-footer">
					<span class="navbar-text">
						&copy; {{ date('Y') }} <a href="#">Proyecto</a> by <a href="" target="_blank">M.A</a>
					</span>
				</div>
			</div>
			<!-- /footer -->
		</div>
		<!-- /main content -->
	</div>
	<!-- /page content -->

@include('layouts.modals')
</body>

	<!-- Core JS files -->
	<script src="/global_assets/js/main/jquery.min.js"></script>
	<script src="/global_assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="/global_assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="/global_assets/js/plugins/ui/ripple.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script src="/global_assets/js/plugins/visualization/d3/d3.min.js"></script>
	<script src="/global_assets/js/plugins/visualization/d3/d3_tooltip.js"></script>
	<script src="/global_assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script src="/global_assets/js/plugins/ui/moment/moment.min.js"></script>
	<script src="/global_assets/js/plugins/pickers/daterangepicker.js"></script>
	<script src="/assets/js/app.js"></script>
	<script src="/global_assets/js/plugins/uploaders/fileinput/plugins/purify.min.js"></script>
    <script src="/global_assets/js/plugins/uploaders/fileinput/plugins/sortable.min.js"></script>
    <script src="/global_assets/js/plugins/uploaders/fileinput/fileinput.min.js"></script>
	<script src="/global_assets/js/demo_pages/uploader_bootstrap.js"></script>
    <script src="/global_assets/js/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/global_assets/js/plugins/datatables/dataTables.bootstrap4.min.js"></script>
    <script src="/global_assets/js/plugins/datatables/dataTables.responsive.min.js"></script>
	<script src="/global_assets/js/plugins/datatables/datetime.js"></script>
    {!! Html::script('/plugins/sweetalert2/sweetalert2-8.11.8.all.min.js') !!}
	<script src="/global_assets/js/plugins/loadMask/jquery.loadmask.min.js"></script>
	<script src="/global_assets/js/plugins/extensions/jquery_ui/interactions.min.js"></script>
	<script src="/global_assets/js/plugins/forms/selects/select2.min.js"></script>
	<script src="/global_assets/js/plugins/forms/selects/bootstrap_multiselect.js"></script>
	<script src="/global_assets/js/demo_pages/form_multiselect.js"></script>
	<script src="/global_assets/js/demo_pages/form_select2.js"></script>
    <script src="/js/bootstrap-notify.js"></script>

    {!! Html::script('/plugins/select2-master/dist/js/i18n/es.js') !!}

    <script src="/plugins/Inputmask-5.x/dist/jquery.inputmask.min.js"></script>

<script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"></script>
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/highcharts-more.js"></script>
<script src="https://code.highcharts.com/modules/solid-gauge.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<script>
    $(function () {
        $('div.alert').not('.alert-important').delay(3000).slideUp();

        $('[data-toggle="tooltip"]').tooltip();

        $('.datera').daterangepicker({
            "autoApply": true,
            "startDate": "{{ date('Y-m').'-01' }}",
            "locale": {
                "format": "YYYY-MM-DD",
                "separator": " | ",
                "applyLabel": "Aplicar",
                "cancelLabel": "Cancelar",
                "fromLabel": "Desde",
                "toLabel": "Hasta",
                "customRangeLabel": "Personalizar",
                "daysOfWeek": [
                    "Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"
                ],
                "monthNames": [
                    "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Setiembre", "Octubre", "Noviembre", "Diciembre"
                ]
            }
        });

        $(".date").inputmask('9999-99-99');

        $(".zipcode").inputmask('99999');

        $(".phone").inputmask('(999) 9-99-99');
    });

    showError = function (sMessage) {
        Swal.fire({
            icon: 'error',
            type: "warning",
            title: "Mensajes del sistema",
            text: sMessage,
            confirmButtonText: "Aceptar"
        });
        return false;
    };

    showSuccess = function (sMessage) {
        Swal.fire({
            icon: 'success',
            title: "Mensajes del sistema",
            html: sMessage,
            type: "success",
            confirmButtonText: "Aceptar"
        });
        return false;
    };

    showNotification = function(from, align, $html_text, $type_name) {
        type = ['', 'info', 'danger', 'success', 'warning', 'rose', 'primary'];

        //color = Math.floor((Math.random() * 6) + 1);

        $.notify({
            icon: "fa fa-check-circle-o",
            message: $html_text

        }, {
            type: $type_name,
            timer: 1500,
            placement: {
                from: from,
                align: align
            }
        });
    };

    maskform = function(){
        $("#maskfullscreen").css("z-index", 99999).mask("Guardando información, espere...");
    };

    unmaskform = function(){
        $("#maskfullscreen").css("z-index", -1).unmask();
    };

    OpenModalFilters = function () {
        $("#modalFilters").modal('show');
    };

    ResetModalFilters = function () {
        $("#form_filters")[0].reset();
        SearchData();
    };

    FilterData = function () {
        $("#modalFilters").modal('hide');
        SearchData();
    };
</script>
	@yield('scripts')
</html>
