<?php

namespace App\Services;

use App\Http\Controllers\AppBaseController;
use App\Interfaces\IServices;
use App\Models\ApiError;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\SystemLog;
use App\Exceptions\AppException;
use Illuminate\Support\Facades\Auth;
use Laracasts\Flash\Flash;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Str;

class UserService extends AppBaseController implements IServices
{

    public function dataTable(Request $request){

        $apiError =  new ApiError();
        $table = User::where('trash',false);

        try {
            return Datatables::of($table)->make(true);
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            $this->setLog($ex->getMessage(), SystemLog::Exception);
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError("Error, consulte con su administrador.");
            $this->setLog($ex->getMessage(), SystemLog::Exception);
            Flash::error(__('Error, intente de nuevo más tarde'));
        }

        return $apiError;

    }

    public function add(Request $request){
        $apiError =  new ApiError();
        try{
            $input = $request->all();
            $input['password'] = bcrypt($input['password']);
            $input['remember_token'] = Str::random(32);
            $input['avatarPath'] = "profile/user.png";
            $row = User::create($input);
            $apiError->modelo =  $row ;
            Flash::success(__('Registro creado correctamente'));
            $description = "add" . " " . $row->name;
            $this->saveHistory('post','user.add', $description);
        }catch(AppException $ex ){
            $apiError->setError("Error, consulte con su administrador.");
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }
        return $apiError;
    }

    public function update($id,Request $request){
        $apiError =  new ApiError();
        try{
            $row = $this->find($id);
            if ($row == null) {
                Flash::error(__('Registro no encontrado'));
                return redirect(route('user.index'));
            }
            if ($request['password'] != '') {
                $request['password'] = bcrypt($request['password']);
            } else {
                $request['password'] = $row->password;
            }
            $input = $request->all();
            $row->update($input);
            Flash::success(__('Registro actualizado correctamente'));
            $description = "update" . " " . $row->name;
            $this->saveHistory('patch','user.update', $description);
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }
        return $apiError;
    }

    public function find($id){
        return User::find($id);
    }

    public function all(Request $request){

    }

    public function delete($id){
        $apiError =  new ApiError();
        try{
            $row = $this->find($id);
            if($row == null){
                throw new AppException(__('Registro no encontrado'));
            }
            $row->trash = 1;
            $row->save();
            Flash::success(__('Registro eliminado correctamente'));
            $description = "delete" . " " . $row->name;
            $this->saveHistory('delete','user.delete', $description);
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }
        return $apiError;
    }

}
