<?php

namespace App\Services;

use App\Http\Controllers\AppBaseController;
use App\Interfaces\IServices;
use App\Models\ApiError;
use Illuminate\Http\Request;
use App\Models\SystemLog;
use App\Exceptions\AppException;
use Laracasts\Flash\Flash;
use Yajra\Datatables\Datatables;
use App\Models\DocumentPath;
use Illuminate\Support\Facades\DB;

class HomeService extends AppBaseController
{

    public function getWidgeByFamilyId($familyId){

        $apiError =  new ApiError();

        try {
            $datawidget = DocumentPath::where('document_paths.trash',0)->where('platforms.platformFamilyId', '=', $familyId)
            ->leftjoin('platforms', 'document_paths.platformId', '=', 'platforms.id')
            ->leftjoin('platform_families', 'platforms.platformFamilyId', '=', 'platform_families.id')
            ->select(
                DB::raw('platformId'),
                DB::raw('platforms.name AS platformName'),
                DB::raw('platforms.enabled AS status'),
                DB::raw('date(platforms.created_at) AS createdAt'),
                DB::raw('platforms.storageCapacity AS storageCapacity'),
                DB::raw('ROUND((sum(fileSize) / 1024) / 1024, 2) AS storageConsumido'),
                DB::raw('ROUND(sum(fileSize), 2) AS bytesConsumed'),
                DB::raw('ROUND((sum(fileSize) / 1024), 2) AS kilobytesConsumed'),
                DB::raw('ROUND((sum(fileSize) / 1024) / 1024, 2) AS megabytesConsumed'),
                DB::raw('ROUND(SUM((document_paths.fileSize/1024) / 1024)/1024) AS gigabytesConsumed')
            )->groupBy('document_paths.platformId')->get();
            #dd($datawidget);
            $apiError->modelo = $datawidget;
            return  $apiError;
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }

        return $apiError;

    }

    public function widgetByFamily(){

        $apiError =  new ApiError();

        try {

            $datawidget = DocumentPath::where('document_paths.trash',0)
            ->leftjoin('platforms', 'document_paths.platformId', '=', 'platforms.id')
            ->leftjoin('platform_families', 'platforms.platformFamilyId', '=', 'platform_families.id')
            ->select(
                DB::raw('platform_families.id as id'),
                DB::raw('platform_families.name AS familyName'),
                DB::raw('date(platform_families.created_at) AS createdAt'),
                DB::raw('ROUND(sum(fileSize), 2) AS bytesConsumed'),
                DB::raw('ROUND((sum(fileSize) / 1024), 2) AS kilobytesConsumed'),
                DB::raw('ROUND((sum(fileSize) / 1024) / 1024, 2) AS megabytesConsumed'),
                DB::raw('platform_families.enabled as status'),
                )->groupBy('platform_families.id')->get();
            $apiError->modelo = $datawidget;
            return  $apiError;

        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }

        return $apiError;

    }

    public function getPorcentajeByPlatform($familyId){

        $apiError =  new ApiError();

        try {

            $datawidget = DocumentPath::where('document_paths.trash',0)->where('platforms.platformFamilyId', '=', $familyId)
            ->leftjoin('platforms', 'document_paths.platformId', '=', 'platforms.id')
            ->leftjoin('platform_families', 'platforms.platformFamilyId', '=', 'platform_families.id')
            ->select(
                DB::raw('platformId'),
                DB::raw('platforms.name AS name'),
                DB::raw('ROUND((sum(fileSize) / 1024) / 1024, 2) AS value')
            )->groupBy('document_paths.platformId')->get();

            $apiError->modelo = $datawidget;
            return  $apiError;

        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }

        return $apiError;

    }

    public function getStorageUsedByYear($familyId){

        $apiError =  new ApiError();

        try {

            $table = DocumentPath::where('document_paths.trash', 0)->where('platforms.platformFamilyId', '=', $familyId)->whereYear('document_paths.created_at', '=' , date('Y'))
            ->leftjoin('platforms', 'document_paths.platformId', '=', 'platforms.id')
            ->leftjoin('platform_families', 'platforms.platformFamilyId', '=', 'platform_families.id')
            ->select(
                DB::raw('document_paths.platformId'),
                DB::raw('platforms.name AS platformName'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 1 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) ENE'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 2 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) FEB'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 3 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) MAR'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 4 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) ABR'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 5 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) MAY'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 6 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) JUN'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 7 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) JUL'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 8 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) AGO'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 9 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) SEP'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 10 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) OCT'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 11 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) NOV'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 12 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) DIC')
            )->groupBy(['document_paths.platformId'])->get();
            $apiError->modelo = $table;
            return  $apiError;

        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }
        return $apiError;
    }

    public function getStorageUsedByYearAndFamily(){

        $apiError =  new ApiError();

        try {
            $table = DocumentPath::where('document_paths.trash', 0)->whereYear('document_paths.created_at', '=' , date('Y'))
            ->leftjoin('platforms', 'document_paths.platformId', '=', 'platforms.id')
            ->leftjoin('platform_families', 'platforms.platformFamilyId', '=', 'platform_families.id')
            ->select(
                DB::raw('platform_families.id as id'),
                DB::raw('platform_families.name AS familyName'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 1 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) ENE'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 2 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) FEB'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 3 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) MAR'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 4 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) ABR'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 5 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) MAY'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 6 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) JUN'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 7 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) JUL'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 8 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) AGO'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 9 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) SEP'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 10 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) OCT'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 11 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) NOV'),
                DB::raw('SUM(CASE WHEN MONTH(document_paths.created_at) = 12 THEN ROUND((fileSize / 1024) / 1024,2) ELSE 0 END) DIC')
            )->groupBy('platform_families.id')->get();
            $apiError->modelo = $table;
            return  $apiError;
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }
        return $apiError;
    }

    public function getPorcentajeByFamily(){

        $apiError =  new ApiError();

        try {

            $datawidget = DocumentPath::where('document_paths.trash',0)
            ->leftjoin('platforms', 'document_paths.platformId', '=', 'platforms.id')
            ->leftjoin('platform_families', 'platforms.platformFamilyId', '=', 'platform_families.id')
            ->select(
                DB::raw('platform_families.id as id'),
                DB::raw('platform_families.name AS name'),
                DB::raw('ROUND((sum(fileSize) / 1024) / 1024, 2) AS value')
            )->groupBy('platform_families.id')->get();
            $apiError->modelo = $datawidget;
            return  $apiError;

        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }

        return $apiError;

    }

}
