<?php

namespace App\Services;

use App\Http\Controllers\AppBaseController;
use App\Interfaces\IServices;
use App\Models\ApiError;
use Illuminate\Http\Request;
use App\Models\SystemLog;
use App\Exceptions\AppException;
use Laracasts\Flash\Flash;
use App\Models\General;
use Yajra\Datatables\Datatables;

class GeneralService extends AppBaseController implements IServices
{
    public function dataTable(Request $request){

        $apiError =  new ApiError();
        $table = General::where('trash',false);

        try {
            return Datatables::of($table)->make(true);
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }

        return $apiError;

    }

    public function add(Request $request){
        $apiError =  new ApiError();
        try{
            $input = $request->all();
            $apiError->modelo = General::create($input);
            $description = "Nueva configuración de storga";
            $this->saveHistory('post','generalservice.add', $description);
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }
        return $apiError;
    }

    public function update($id,Request $request){
        $apiError =  new ApiError();
        try{
            $row = $this->find($id);
            $input = $request->all();
            $row->update($input);
            $description = "edición de la configuración de storga";
            $this->saveHistory('Patch','generalservice.update', $description);
            Flash::success(__('Registro actualizado correctamente'));
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error(__('Error, intente de nuevo más tarde'));
        }
        return $apiError;
    }

    public function find($id){
        return General::find($id);
    }

    public function getGeneral(){
        return General::find(1);
    }

    public function all(Request $request){

    }

    public function delete($id){
        $apiError =  new ApiError();
        try{
            $row = $this->find($id);
            if($row == null){
                throw new AppException(__('Registro no encontrado'));
            }
            $row->trash = 1;
            $row->save();
            $description = "eliminar configuración de storga";
            $this->saveHistory('delete','generalservice.delete', $description);
            Flash::success(__('Registro eliminado correctamente'));
        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }catch(\Exception $ex ){
            $apiError->setError($ex->getMessage());
            $this->setLog($ex->getMessage(), SystemLog::Exception);
        }
        return $apiError;
    }

}
