<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use App\Models\SystemLog;
use App\Exceptions\AppException;
use App\Models\ApiError;
use App\Http\Requests\CreateUserRequest;
use App\Http\Requests\UpdateUserRequest;
use App\Services\UserService;
use Laracasts\Flash\Flash;

class UserController extends Controller
{

    private $service;

    public function __construct(UserService $service)
    {
        $this->middleware('auth');
        $this->service = $service;
    }

    public function datatable(Request $request) {
        $table = $this->service->dataTable($request);
        return $table;
    }

    public function index() {
        return view('user.index');
    }

    public function create() {
        return view('user.create');
    }

    public function store(CreateUserRequest $request) {
        $apiError = $this->service->add($request);
        return redirect(route('users.index'));
    }

    public function edit($id) {
        $row = $this->service->find($id);
        if ($row == null) {
            Flash::error(('Registro NO encontrado'));
            return redirect(route('user.index'));
        }
        return view('user.edit')->with('user', $row);
    }

    public function update($id, UpdateUserRequest $request) {
        $apiError = $this->service->update($id, $request);
        return redirect(route('users.index'));
    }

    public function getData(request $request) {
        $row = $this->service->find($request->id);
        return response()->json([
            'data'   => $row
        ]);
    }

    public function delete(Request $request) {
        $apiError = $this->service->delete($request->id);
        return response()->json($apiError);
    }


    public function profile(){
        $user = User::whereId(Auth::user()->id)->first();
        return view('user.profile')->with('user', $user);
    }

    public function profileUpdated(Request $request){
        $apiError =  new ApiError();
        try{
            $user = User::whereId($request->id)->first();

            if(isset($request->file()['profilePath'])) {
                $file = $request->file()['profilePath'];
                $sDirectory = public_path() . '/profiles/';
                if (!File::exists($sDirectory)) {
                    File::makeDirectory($sDirectory, 0755, true);
                }
                $filename = uniqid() . "." . pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION);
                $sPath = $sDirectory.'/'. $filename;
                File::move($file, $sPath);
                $sPathFull = 'profiles/'.$filename;
                $user->profilePath = $sPathFull;
            }

            $user->name = $request->input('name');
            if($request->get('password') != '')
                $user->password = bcrypt($request->get('password'));

            if(!$user->isClean()){
                $user->save();
            }
            return redirect(route('user-updated'));

        }catch(AppException $ex ){
            $apiError->setError($ex->getMessage());
            Flash::error($ex->getMessage());
        }catch(\Exception $ex ){
            $apiError->setError(__('messages.error'));
            $this->setLog($ex->getMessage(), SystemLog::Exception);
            Flash::error(__('messages.error'));
        }
        return $apiError;
    }

}
