<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Services\HomeService;

class HomeController extends Controller
{
    private $service;

    public function __construct(HomeService $service)
    {
        $this->middleware('auth');
        $this->service = $service;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $apiError = $this->service->widgetByFamily();
        return view('dashboard')->with('datawidget' , $apiError->modelo);
    }

    public function getStatisticByFamily($familyId)
    {
        $apiError = $this->service->getWidgeByFamilyId($familyId);
        return view('dashboardbyfamily')->with('datawidget' , $apiError->modelo)->with('familyId', $familyId);
    }

    public function getStorageUsedByYear(Request $request) {
        $apiError = $this->service->getStorageUsedByYear($request->familyId);
        return response()->json([
             $apiError
        ]);
    }

    public function getStorageUsedByYearAndFamily() {
        $apiError = $this->service->getStorageUsedByYearAndFamily();
        return response()->json([
             $apiError
        ]);
    }

    public function getPorcentajeByPlatform(Request $request) {
        $apiError = $this->service->getPorcentajeByPlatform($request->familyId);
        return response()->json([
             $apiError
        ]);
    }

    public function getPorcentajeByFamily() {
        $apiError = $this->service->getPorcentajeByFamily();
        return response()->json([
             $apiError
        ]);
    }

}
