<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Contracts\JWTManager;
use Tymon\JWTAuth\Facades\JWTAuth as JWT;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['login']]);
    }

    public function login(Request $request)
    {

        $credentials = $request->only(['email', 'password']);
        $user = User::where('email',$request->email)->first();
        if (!$token =  auth()->guard('api')->claims([
            'email'  => $request->email
        ])->attempt($credentials))
        {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
        return $this->respondWithToken($token);
    }

    public function me()
    {
        return response()->json(auth()->user());
    }

    public function refresh()
    {
        return $this->respondWithToken(auth()->refresh());
    }

    public function logout()
    {
        auth()->logout(true);
        return response()->json(['message' => 'session cerrada exitosamente'], 200);
    }

    protected function respondWithToken($token)
    {
        return response()->json([
            'accessToken' => $token,
            'expires_in'   => auth()->guard('api')->factory()->getTTL() * 60,
        ]);
    }
}
